/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xboard.h
 *       board properties and generic functions
 * -----------------------------------------------------------------*/

 
#ifndef XBOARD_H_INCLUDED
#define XBOARD_H_INCLUDED

#include <xbddefs.h>

#ifdef __cplusplus
extern "C" {
#endif

  
/********************************************************************
  Best Status *******************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXStatusClear( /* @statusclear */
  bx_handletype handle,
  bx_statustype prop
);

CLI bx_errtype EXPORT BestXStatusRead(   /* @statusread */
  bx_handletype handle,
  bx_statustype  prop,
  bx_int32 *val                         /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXStatusDump(   /* @statusdump */
  bx_handletype  handle,
  bx_charptrtype file        /* $"c:\\bx_status.txt" */
);

/********************************************************************
  Board properties **************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXBoardSet(     /* @boardset */
  bx_handletype    handle,
  bx_boardtype prop, 
  bx_int32     val   
);


CLI bx_errtype EXPORT BestXBoardGet(     /* @boardget */
  bx_handletype    handle,
  bx_boardtype prop,
  bx_int32     *val                      /* #RETURN "0x%08lx" */
);


CLI bx_errtype EXPORT BestXBoardDefaultSet ( /* @boarddefset */
  bx_handletype  handle
);


CLI bx_errtype EXPORT BestXBoardProg(      /* @boardprog */
  bx_handletype handle
);


CLI bx_errtype EXPORT BestXBoardRead(      /* @boardread */
  bx_handletype    handle
);

/********************************************************************
  Board initialization **********************************************
 *******************************************************************/
 
CLI bx_errtype EXPORT BestXBoardInit(      /* @boardinit */
  bx_handletype    handle,
  bx_int32 SoftForce
);

/********************************************************************
  Expansion ROM *****************************************************
 *******************************************************************/

#ifndef SWIG
CLI bx_errtype EXPORT BestXExpRomWrite(  /* @expromwrite */                         
  bx_handletype handle,
  bx_int32    numbytes,   
  bx_int8  * data 
);
#else
/* chris: 
   Do not change the parameter names !
   SWIG relies on that 
*/
bx_errtype EXPORT BestXExpRomWrite(                        
  bx_handletype handle,
  bx_int32    NumBytesFor8BitDataIn,   
  bx_int8  *  DataFor8BitDataIn                      
);
#endif

#ifndef SWIG
CLI bx_errtype EXPORT BestXExpRomRead(  /* @expromread */
  bx_handletype handle,
  bx_int32     offset,           
  bx_int32     numbytes,  
  bx_int8      * data     /* @data #RETURN intelhexdump(data,numbytes,cmd,NULL,NULL) [numbytes] */
);
#else
/* chris: 
   Do not change the parameter names !
   SWIG relies on that 
*/
CLI bx_errtype EXPORT BestXExpRomRead(  
  bx_handletype handle,
  bx_int32     offset,           
  bx_int32     NumBytesFor8BitDataOut,  
  bx_int8      * DataFor8BitDataOut     
);
#endif

/*****************************************************************************
 * Run code in RAM at addr (not documented, don't use)
 *****************************************************************************/
CLI bx_errtype EXPORT BestXRunRam (
  bx_handletype handle,
  bx_int32 jmpAddr,  /* @addr $0 */
  bx_bool immediate  /* @imm $0 */
);

/*****************************************************************************
 * board mem alloc/free routines (not documented, don't use)
 *****************************************************************************/
bx_errtype EXPORT BestXBoardMemAlloc (
  bx_handletype handle,
  bx_int32 size,
  bx_int32 * addr
  );

bx_errtype EXPORT BestXBoardMemFree (
  bx_handletype handle,
  bx_int32 addr
  );

/*****************************************************************************
 * Misc
 *****************************************************************************/

CLI bx_errtype EXPORT BestXRequestAssert(      /* @requestassert */
  bx_handletype    handle,
  bx_int32 clocks
);

#ifdef __cplusplus
}
#endif


#endif

